%!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
% Sets the legend in the legend frame: the legend is created as ...
% a patch of rectangular elements
%!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
function myleg(cmap,minsp,maxsp,minre,maxre,auto)

num=14;                                      % number of colors
xin=.02; yin=.1; dlx=.15; dly=1./(num+3); 

dsp=maxsp-minsp+1.e-30;
idim=size(cmap); idim1=idim(1);
lcoor=[zeros(num+1,1) [0:dly:dly*num]'; ...  % coordinates and connect. for rectangles
       dlx*ones(num+1,1) [0:dly:dly*num]'];
lconnec=[[1:num]' [num+2:2*num+1]' ...
         [num+3:2*num+2]' [2:num+1]'];
ltcolor=minsp*ones(num,1)+...
          dsp/(num-1)*[0:num-1]';
axes(findobj(gcf,'Tag','Legend'));           % sets focus on legend axes
axis([0 1 0 1]);                             % sets scaling inside axes defined above
patch('faces',lconnec,...
      'vertices',lcoor,...
      'FaceVertexCData',ltcolor,...
      'FaceColor','flat');
text(lcoor(1:num,1)+1.5*dlx,...              % adds text 
     lcoor(1:num,2)+.5*dly,...
     [num2str(ltcolor)], ...
     'Fontsize',8,...
     'HorizontalAlignment','left');

if auto==0,                                  % adds text if auto mode
 coorx=xin;
 coory=lcoor(1,2)-dly;
 text(coorx, coory,...
      ['Min: ',num2str(minre)],...
      'Fontsize',8,...
      'HorizontalAlignment','left');
 coory=lcoor(2*(num+1),2)+dly;
 text(coorx, coory,...
      ['Max: ',num2str(maxre)],...
      'Fontsize',8,...
      'HorizontalAlignment','left');
end

axes(findobj(gcf,'Tag','PlotAxes'));         % resets focus on plot window



