%!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
%!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
% Post manager
%!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
%!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
function interface(Action,stringopt,stringpost)

switch Action

case 'Initialize'

 CreateWindow(stringopt,stringpost);         %Initialize graphical window
 
case 'Refresh'

 PropPopup=findobj(gcf,'Tag','RangePopUp');  % finds handle of object with given Tag 
 PlotType=popupstr(PropPopup);               % gets string in popup menu
 if strcmp(PlotType,'manual')==1,            % if manual option active
  PropString=get(PropPopup,'UserData');      % gets name of the text box with vector
  PropName=get(PropString,'Tag');            % gets the tag
  newstr=deblank(get(PropString,'String'));
  infopost.val=eval(newstr);
  infopost.auto=0;  
 else
  infopost.val=[0 0];                        % if auto mode active
  infopost.auto=1;
 end    
 
 PropEdge=findobj(gcf,'Tag','EdgePopUp');    % finds handle of object with given Tag 
 EdgeAct=popupstr(PropEdge);                 % gets string in popup menu
 if strcmp(EdgeAct,' on')==1,
  infopost.edge=1;   
 else
  infopost.edge=0;   
 end
 
 PropStyle=findobj(gcf,'Tag','PlotType');
 infopost.ptype=popupstr(PropStyle);         % gets string in popup menu
 
 axes(findobj(gcf,'Tag','Legend'));
 cla                                         % clears everything on legend window
 axes(findobj(gcf,'Tag','PlotAxes'));
 cla                                         % clears everything on graphical window

 eval(stringpost)
 
end 


%!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
% creates window for the first time
%!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
function CreateWindow(stringval,stringpost);

StdColor = get(0,'DefaultUIcontrolBackgroundColor');
StdColorPicture=[.93 .93 .93];
ValRangeVec=[0 0];

a = figure(...                               % opens a new figure
         'Color',StdColorPicture, ...        % sets the overall dimensions of the graphical
         'Units','normalized', ...           % window (plot area and option area)
         'Position',[.02 .12 .95 .82], ...
         'Name','Post Window',...
         'NumberTitle','off',...  
         'Tag','Figure');
b = axes(...                                 % sets plotting region
         'Parent',a, ...
         'Units','normalized', ...
         'Color',StdColorPicture, ...
         'Position',[.03 .04 .7 .93], ...
         'Units','Normalized',...
         'Tag','PlotAxes', ...
         'Box','off');
axis off;
b = axes(...                                 % sets region for legend
         'Parent',a, ...
         'Units','normalized', ...
         'Color',StdColorPicture, ...
         'Position',[.68 .3 .08 .5], ...
         'Units','Normalized',...
         'Tag','Legend', ...
         'Box','off');
axis off;
     
TextXInit=.8;
SepX=.01;

b = uicontrol(...                            % Global post frame
         'Parent',a, ...
         'Units','Normalized',...
         'BackgroundColor',[0 0 .5], ...
         'Position',[TextXInit-2*SepX ...
                     0 ...
                     1-TextXInit+2*SepX ...
                     1],...
         'Units','Normalized',...
         'Style','frame');

TextYInit=.8;                                % Controls for Plot Type
TextWidth=.09;
TextHeight=.03;
SepY=.01;
BoxXInit=TextXInit+TextWidth;
BoxYInit=TextYInit;
BoxWidth=.09;
BoxHeight=.03;
FrameWidth=TextWidth+BoxWidth+2*SepX;
FrameHeight=TextHeight+BoxHeight;
calla=['interface(''Refresh'',''' stringval ''',''' stringpost ''');'];

b = uicontrol(...                            % Frame
         'Parent',a, ...
         'Units','Normalized',...
         'BackgroundColor',StdColor, ...
         'Position',[TextXInit-SepX ...
                     TextYInit-SepY ...
                     FrameWidth ...
                     FrameHeight], ...
         'Units','Normalized',...
         'Style','frame');
b = uicontrol(...                            % Description Text Box
         'Parent',a, ...
         'Units','Normalized',...
         'BackgroundColor',StdColor, ...
         'HorizontalAlignment','left', ...
         'Position',[TextXInit ...
                     TextYInit ...
                     TextWidth ...
                     TextHeight], ...
         'Units','Normalized',...
         'String','Choose plot type', ...
         'Style','text');
PTypePop = uicontrol(...                     % Pop up choice between different options
         'Parent',a, ...
         'Unit','Normalized', ...
         'BackgroundColor',[1 1 1], ...
         'Style','popup', ...
         'Position',[BoxXInit ...
                     BoxYInit ...
                     BoxWidth ...
                     BoxHeight], ...
         'Units','Normalized',...
         'String',stringval, ...
         'Callback',calla, ...
         'Tag','PlotType');

TextYInit=TextYInit-4*FrameHeight;           % Controls for Range Limits
FrameHeight=TextHeight+BoxHeight+3*SepY;
BoxYInit=TextYInit;
b = uicontrol(...                            % Frame
         'Parent',a, ...
         'Units','Normalized',...
         'BackgroundColor',StdColor, ...
         'Position',[TextXInit-SepX ...
                     TextYInit-SepY ...
                     FrameWidth ...
                     FrameHeight], ...
         'Units','Normalized',...
         'Style','frame');
b = uicontrol(...                            % Description Box
         'Parent',a, ...
         'Units','Normalized',...
         'BackgroundColor',StdColor, ...
         'HorizontalAlignment','left', ...
         'Position',[TextXInit ...
                     TextYInit+SepY ...
                     TextWidth ...
                     TextHeight], ...
         'Units','Normalized',...
         'String','Range limits', ...
         'Style','text');
ValRangeStr = uicontrol(...                  % Text Box for entering values
         'Parent',a, ...
         'Units','Normalized',...
         'BackgroundColor',[1 1 1], ...
         'Position',[BoxXInit ...
                     BoxYInit ...
                     BoxWidth ...
                     BoxHeight], ...
         'String',mat2str(ValRangeVec), ...
         'Style','edit', ...
         'Horiz','left', ...
         'UserData',ValRangeVec, ...
         'Tag','RangeValue');        
b = uicontrol(...                            % pop up choice between auto and manual 
         'Parent',a, ...
         'Unit','Normalized', ...
         'BackgroundColor',[1 1 1], ...
         'Style','popup', ...
         'Position',[BoxXInit ...
                     BoxYInit+BoxHeight+SepY...
                     BoxWidth ...
                     BoxHeight], ...
         'Units','Normalized',...
         'String','auto|manual', ...
         'UserData',ValRangeStr, ...
         'Callback',calla, ...
         'Tag','RangePopUp');

        
TextYInit=TextYInit-2*FrameHeight;           % Controls for Edge visibility
FrameHeight=BoxHeight+3*SepY;
BoxYInit=TextYInit;
b = uicontrol(...                            % Frame
         'Parent',a, ...
         'Units','Normalized',...
         'BackgroundColor',StdColor, ...
         'Position',[TextXInit-SepX ...
                     TextYInit-SepY ...
                     FrameWidth ...
                     FrameHeight], ...
         'Units','Normalized',...
         'Style','frame');
b = uicontrol(...                            % Description Box
         'Parent',a, ...
         'Units','Normalized',...
         'BackgroundColor',StdColor, ...
         'HorizontalAlignment','left', ...
         'Position',[TextXInit... 
                     TextYInit...
                     TextWidth...
                     TextHeight], ...
         'Units','Normalized',...
         'String','Edge visibility', ...
         'Style','text');
PEdgePop = uicontrol(...                     % Pop up choice between different options
         'Parent',a, ...
         'Unit','Normalized', ...
         'BackgroundColor',[1 1 1], ...
         'Style','popup', ...
         'Position',[BoxXInit...
                     BoxYInit...
                     BoxWidth...
                     BoxHeight], ...
         'Units','Normalized',...
         'String',' off| on', ...
         'Callback',calla, ...
         'Tag','EdgePopUp');

b = uicontrol(...                            % Close button
         'Parent',a, ...
         'Unit','Normalized', ...
         'CallBack','close(gcf)', ...
         'Position',[TextXInit-SepX .1 ...
                     FrameWidth ...
                     FrameHeight], ...
         'Units','Normalized',...
         'String','Close', ...
         'Tag','Close');
     
interface('Refresh',stringval,stringpost)    % initializes window with undeformed mesh

