
%!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
%!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
% file: tire_contact_T3.M
% dynamic analysis for the tire-surface contact
%!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
%!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

addpath(genpath('.'))

clear all

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% input phase
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

fname='tire.inp';                            % fixed input file (mesh can be modified)
pname='input/';
[analysis,materials,connec coor,...           % reads input file
   dof,displ,TD]=read_input(pname,fname,'');

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% pre phase: excess estimate of non-zero coeffs
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

Ek=ones(analysis.NN,1);                      % initialisation of Ek
for e=1:analysis.NE,                         % loop over elements
  nodes=connec(e,:);
  Ek(nodes)=Ek(nodes)+2;                     % Ek is incremented on connectivity nodes
end
ncoeffs=4*sum(Ek);                           % estimate of coefficients in K

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% assemblage phase: K, M and F
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

K=spalloc(analysis.neq,analysis.neq,ncoeffs);% allocates sparse matrix
M=zeros(analysis.neq,1);                     % allocates vector for lumped mass matrix
F=zeros(analysis.neq,1);                     % allocates rhs vector

D=2;                                         % problem dimensionality
Dne=D*analysis.ne;                           % number of nodal values in one surface el.
Dns=D*analysis.ns;                           % number of nodal values in one line el.
for e=1:analysis.NE,                         % assemblage phase
  nodes=connec(e,:);                         % element nodes
  T=coor(nodes,:);                           % creates element
  Ke=stiff_linel_T3(T,materials.A);          % computes element stiffness matrix
  Me=mass_lumped_T3(T,materials.rho);        % computes element mass matrix
  rhog=materials.rho*analysis.gravity;
  Fe=nf_gravity_T3(T,rhog);
  dofe=reshape(dof(nodes,:)',[1,Dne]);       % list of dof associated to element
  pe=find(dofe>0);                           % gets position of unknown displ. compon.
  Ie=dofe(pe);                               % gets value of associated DOFs 
  K(Ie,Ie)=K(Ie,Ie)+Ke(pe,pe);               % stiffness matrix assemblage
  M(Ie)=M(Ie)+Me(pe);                        % mass matrix assemblage
  F(Ie)=F(Ie)+Fe(pe);                        % rhs assemblage
end                                          

uu=eigs(K,sparse(diag(M)),1);                % max stable time step (expl. analysis) 
stable_time_increment=2/sqrt(uu)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Time integration
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
               
%-----------------------------------------------------------------------------------------
 bkgcol=.93*[1 1 1];
 a = figure('Color',bkgcol,'Units','normalized','Position',[.4 .05 .4 .7], ...
           'Name','Post Window','NumberTitle','off','Tag','AspectDemo');
 b = axes('Parent',a,'Units','normalized','Color',bkgcol, ...
         'Position',[.03 .04 .97 .93],'Units','Normalized',...
         'Tag','ActiveAxes','Box','off');
 axis equal
 axis off    
%-----------------------------------------------------------------------------------------

Dt=analysis.dt;
nstep=floor(analysis.tf/Dt);                 % number of time steps assuming constant dt                      

U=zeros(analysis.neq,1);
Ud=zeros(analysis.neq,1);
Ud(2:2:analysis.neq)=analysis.invel(2);
coorf=zeros(analysis.NN,2);

Udd=M.\F;                                    % initial value of accelerations
Ud=Ud+Dt/2*Udd;                              % and of velocities

counter=0;
for step=1:nstep,                            % loop over time steps
  counter=counter+1;
  U=U+Dt*Ud;                                 % actualisation of displacements
  coorf(:,2)=coor(:,2)+U(2:2:analysis.neq);  % computes actual coordinates
  irow=find(coorf(:,2)<0);                   % and finds active contacts
  Fg=F-K*U;                                  % rhs without contact
  Fg(2*irow)=Fg(2*irow)-...
             analysis.penalty*coorf(irow,2); % adds nodal force prop. to compen.             
  Udd=M.\Fg;                                 % acceleration
  Ud=Ud+Dt*Udd;                              % velocity
 
%-----------------------------------------------------------------------------------------
  if mod(counter,10)==0,                     % plots only every 10 steps
    axes(findobj(gcf,'Tag','ActiveAxes')); 
				cla  
    axis([-7 7 -1 10]);
    axis off;
    coorf(:,1)=coor(:,1)+U(1:2:analysis.neq);
    patch('faces',connec,'vertices',coorf,...
					     'FaceColor',[.85 .85 .85],'EdgeColor',[.5 .5 .5]);
    line([-3 3],[0 0],'Color','k','linewidth',2.);
    pause(.001)
  end 
%-----------------------------------------------------------------------------------------

end

