
%!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
%!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
% FILE: linel_T.m
% Linear elastic analyses for plane problems with linear and quadratic triangles
%!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
%!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

addpath(genpath('.'))

clear all
global displ analysis coor connec stress     % global variables for post-processing                                       

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% preprocessor phase: reads input from file
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

[fname,pname]=uigetfile('input/*.inp',...    % gets name of input file
                        'Choose input file');
                                                                                    
%-----------------------------------------------------------------------------------------
[figmess,t1,t2]=createfigmess;
set(t1,'string','Pre phase');
%-----------------------------------------------------------------------------------------

[analysis,materials,connec,coor,...           % reads input file
   dof,displ,TD]=read_input(pname,fname,t2);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% estimate of number of non-zero coefficients for Morse stocking
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

switch analysis.Etag                         % coeffs of the relation between Nk and Ek
case{'3','3axi'}
  c1=2; c2=1;
case{'6','6axi'}
  c1=3; c2=3;
end
Ek=c1*ones(analysis.NN,1);                   % initialisation of Ek
for e=1:analysis.NE,                         % loop over elements
  nodes=connec(e,:);
  Ek(nodes)=Ek(nodes)+c2;                    % Ek is incremented on connectivity nodes
end
ncoeffs=4*sum(Ek);                           % sum of all the terms in Ek

K=spalloc(analysis.neq,analysis.neq,ncoeffs);% allocates sparse matrix
F=zeros(analysis.neq,1);                     % allocates rhs vector

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% assemblage phase: system matrix and nodal forces due to imposed displ.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%-----------------------------------------------------------------------------------------
set(t1,'string',['Number of elements: ' num2str(analysis.NE)]);
set(t2,'string','Assembling: 0%'); pause(.01);
percold=0;
%-----------------------------------------------------------------------------------------

D=2;                                         % problem dimensionality
Dne=D*analysis.ne;                           % number of nodal values in one surface el.
Dns=D*analysis.ns;                           % number of nodal values in one line el.
for e=1:analysis.NE,                         % stiffness matrix assemblage
	
%-----------------------------------------------------------------------------------------
 perc=10*floor(10*e/analysis.NE);
 if perc~=percold,
  percold=perc;
  set(t2,'string',['Assembling: ' num2str(percold) '%']); pause(.01)
 end
%-----------------------------------------------------------------------------------------

  nodes=connec(e,:);                         % element nodes
  T=coor(nodes,:);                           % creates element
  Ke=eval(['stiff_linel_T',analysis.Etag,... % computes element stiffness matrix
                  '(T,materials.A)']);       
  dofe=reshape(dof(nodes,:)',[1,Dne]);       % list of dof associated to element
  pe=find(dofe>0);                           % gets position of unknown displ. compon.
  Ie=dofe(pe);                               % gets value of associated DOFs 
  K(Ie,Ie)=K(Ie,Ie)+Ke(pe,pe);               % matrix assemblage
  pe_UDe=find(dofe<0);                       % finds pos of UDe
  Ie_UDe=-dofe(pe_UDe);                      % finds pos of UDe in 1D equiv vector
  UDe=displ(Ie_UDe)';                        % gets value of UDe
  F(Ie)=F(Ie)-Ke(pe,pe_UDe)*UDe;             % assemblage of rhs
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% assemblage phase: nodal loads due to surface tractions
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%-----------------------------------------------------------------------------------------
set(t2,'string',['Creating rhs']); pause(.01)
%-----------------------------------------------------------------------------------------

for s=1:analysis.nTD,                        % for each loaded face in the model
  nodes=TD(s).nodes;                         % gets nodes
  idir=TD(s).dir;                            % gets direction
  val=TD(s).val;                             % gets traction value
  L=coor(nodes,:);                           % creates segment   
  Fe=eval(['nf_tractions_T',analysis.Etag,...
			                '(L,val,idir)']); 
  dofs=reshape(dof(nodes,:)',[Dns,1]);       % list of dof associated to element 
  ps=find(dofs>0);                           % finds non-zero entries of dofe
  Is=dofs(ps); 
  F(Is)=F(Is)+Fe(ps);                        % adds to global rhs
end 
 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Solution phase
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%-----------------------------------------------------------------------------------------
set(t2,'string',['Solving system']); pause(.01)
%-----------------------------------------------------------------------------------------

U=K\F;                                       % solution of linear system

clear K F                                    % clears memory

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Post-processing phase: computation of nodal stresses via extrapolation
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

ic=find(dof>0);                              % finds active dofs
displ(ic)=U(dof(ic));                        % and copies solution into displ
stress=zeros(analysis.NN,3);                 % initializes "stress"
counter=zeros(analysis.NN,1);                % initializes "counter"
for e=1:analysis.NE,                         % computes nodal stresses
  nodes=connec(e,:);
  T=coor(nodes,:);                           % creates element
  Ve=reshape(displ(nodes,:)',[Dne,1]);
  stressG=eval(['stressG_linel_T',...        % computes stresses in one element ...
      analysis.Etag,'(T,materials.A,Ve)']);  % at gauss points
  stressN=eval(['G2N_T',...                  % and extrapolates to vertex nodes 
      analysis.Etag,'(T,stressG)']);   
  stress(nodes,:)=stress(nodes,:)+stressN;   % adds stresses to triangle nodes
  counter(nodes)=counter(nodes)+1;
end   
for icomp=1:3
  stress(:,icomp)=stress(:,icomp)./counter;  % naive average of stresses
end

%-----------------------------------------------------------------------------------------
% graphical postprocessing
close(figmess)
interface('Initialize',[' mesh-undef| mesh-def| mesh-both| u1|'...
          ' u2| s11| s22| s12'],'post(infopost)'); 
%-----------------------------------------------------------------------------------------


