H=5;  //  semiwidth of plate
V=20;  //  semiheight of plate
a=1;  //  semilength of crack  (center crack is at x1=x2=0)


lc1=.25;    // element size in middle region
rad1=.02;  // radius of inner "rosette" circle
rad2=1.5*rad1; // radius of outer "rosette" circle
num=6;   // number of elements per quarter of "rosette"
lc2=3.14*rad1/num;
lc4=H/5;

Point(1) = {-H,-a,0.0,lc1};
Point(2) = {H,-a,0.0,lc1};
Point(3) = {H,0.0,0.0,lc1};
Point(4) = {H,a,0.0,lc1};
Point(5) = {-H,a,0.0,lc1};
Point(6) = {-H,0.0,0.0,lc1};

Point(7) = {-a,0.0,0.0,rad1};
Point(8) = {-a-rad1,0.0,0.0,rad1};
Point(9) = {-a,-rad1,0.0,rad1};
Point(10) = {-a+rad1,0.0,0.0,rad1};
Point(11) = {-a,rad1,0.0,rad1};

Point(12) = {a,0.0,0.0,rad1};
Point(13) = {a-rad1,0.0,0.0,rad1};
Point(14) = {a,-rad1,0.0,rad1};
Point(15) = {a+rad1,0.0,0.0,rad1};
Point(16) = {a,rad1,0.0,rad1};

Point(17) = {-a-rad2,0.0,0.0,lc2};
Point(18) = {-a,-rad2,0.0,lc2};
Point(19) = {-a+rad2,0.0,0.0,lc2};
Point(20) = {-a,rad2,0.0,lc2};

Point(21) = {a-rad2,0.0,0.0,lc2};
Point(22) = {a,-rad2,0.0,lc2};
Point(23) = {a+rad2,0.0,0.0,lc2};
Point(24) = {a,rad2,0.0,lc2};

Point(25) = {-a+rad1,0.0,0.0,rad1};
Point(26) = {-a+rad2,0.0,0.0,lc2};
Point(27) = {a-rad2,0.0,0.0,lc2};
Point(28) = {a-rad1,0.0,0.0,rad1};

Point(29) = {-H,-V,0.0,lc4};
Point(30) = {H,-V,0.0,lc4};
Point(31) = {H,V,0.0,lc4};
Point(32) = {-H,V,0.0,lc4};

Line(1) = {1,2};
Line(2) = {2,3};
Line(3) = {3,23};
Line(4) = {23,15};
Line(5) = {15,12};
Line(6) = {12,13};
Line(7) = {13,21};
Line(8) = {21,19};
Line(9) = {19,10};
Line(10) = {10,7};
Line(11) = {7,8};
Line(12) = {8,17};
Line(13) = {17,6};
Line(14) = {6,1};
Line(15) = {7,25};
Line(16) = {25,26};
Line(17) = {26,27};
Line(18) = {27,28};
Line(19) = {28,12};
Line(20) = {3,4};
Line(21) = {4,5};
Line(22) = {5,6};


Circle(23) = {8,7,9};
Circle(24) = {9,7,10};
Circle(25) = {17,7,18};
Circle(26) = {18,7,19};
Circle(27) = {25,7,11};
Circle(28) = {11,7,8};
Circle(29) = {26,7,20};
Circle(30) = {20,7,17};
Circle(31) = {13,12,14};
Circle(32) = {14,12,15};
Circle(33) = {21,12,22};
Circle(34) = {22,12,23};
Circle(35) = {15,12,16};
Circle(36) = {16,12,28};
Circle(37) = {23,12,24};
Circle(38) = {24,12,27};

Line(39) = {1,29};
Line(40) = {29,30};
Line(41) = {30,2};
Line(42) = {4,31};
Line(43) = {31,32};
Line(44) = {32,5};

Line Loop(39) = {1,2,3,-33,-34,8,-26,-25,13,14};
Line Loop(40) = {25,26,9,-24,-23,12};
Line Loop(41) = {33,34,4,-32,-31,7};
Line Loop(42) = {23,24,10,11};
Line Loop(43) = {31,32,5,6};

Line Loop(44) = {21,22,-13,-30,-29,17,-38,-37,-3,20};
Line Loop(45) = {-12,-28,-27,16,29,30};
Line Loop(46) = {18,-36,-35,-4,37,38};
Line Loop(47) = {-11,15,27,28};
Line Loop(48) = {19,-5,35,36};

Line Loop(49) = {39,40,41,-1};
Line Loop(50) = {42,43,44,-21};

Transfinite Line{23,24,31,32,27,28,35,36} = num ;

Plane Surface(1) = {39};
Plane Surface(2) = {40};
Plane Surface(3) = {41};
Plane Surface(4) = {42};
Plane Surface(5) = {43};
Plane Surface(6) = {44};
Plane Surface(7) = {45};
Plane Surface(8) = {46};
Plane Surface(9) = {47};
Plane Surface(10) = {48};
Plane Surface(11) = {49};
Plane Surface(12) = {50};

Physical Line(1) = {40}; 
Physical Line(2) = {43}; 
Physical Surface(3) = {1,2,3,4,5,6,7,8,9,10,11,12}; 

