
%!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
%!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
% FILE: beam_ldisp_T3.m
% large displacements and large rotations elastic analysis (only T3) of a doubly clamped
% beam subjected to compressive load. 
%!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
%!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

addpath(genpath('.'))

clear all

global displ analysis coor connec stress 

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% input phase
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%-----------------------------------------------------------------------------------------
[figmess,t1,t2]=createfigmess;
set(t1,'string','Input phase');
%-----------------------------------------------------------------------------------------

fname='buckling.inp';                        % fixed input file (mesh can be modified)
pname='input/';
[analysis,materials,connec,coor,...          % reads input file
   dof,displ,TD]=read_input(pname,fname,t2);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% preprocessor phase: estimate on non-zero coefficients and allocation of matrices
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

Ek=ones(analysis.NN,1);                      % initialisation of Ek
for e=1:analysis.NE,                         % loop over elements
  nodes=connec(e,:);
  Ek(nodes)=Ek(nodes)+2;                     % Ek is incremented on connectivity nodes
end
ncoeffs=4*sum(Ek);                           % estimate of coefficients in K

K=spalloc(analysis.neq,analysis.neq,ncoeffs);% allocates sparse matrix
F=zeros(analysis.neq,1);                     % allocates rhs vector
Fg=zeros(analysis.neq,1);
disp_k=zeros(analysis.NN,2);

%-----------------------------------------------------------------------------------------
set(t1,'string',['Number of elements: '...
                  num2str(analysis.NE)]);
set(t2,'string','Assembling: 0%');
pause(.01);
percold=0;
%-----------------------------------------------------------------------------------------

D=2;                                         % problem dimensionality
Dne=D*analysis.ne;                           % number of nodal values in one surface el.
Dns=D*analysis.ns;                           % number of nodal values in one line el.

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% rhs vector due to applied constant loads
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

for s=1:analysis.nTD,                        % for each loaded face in the model
 nodes=TD(s).nodes;                          % gets nodes
 dir=TD(s).dir;                              % gets direction
 val=TD(s).val;                              % gets traction value
 L=coor(nodes,:);                            % creates segment   
 Fe=nf_tractions_T3(L,val,dir); 
 dofs=reshape(dof(nodes,:)',[Dns,1]);        % list of dof associated to element 
 ps=find(dofs>0);                            % finds non-zero entries of dofe
 Is=dofs(ps); 
 Fg(Is)=Fg(Is)+Fe(ps);                       % adds to global rhs
end 

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% NR procedure
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

num_step=20;                                 % user choice: number of load steps
delta=1/num_step;                            % fraction of final displacement imposed ...
                                             % at each step           
fid=fopen('./temp/hist.dat','w');            % opens file for saving history of forces
fprintf(fid,'%d\n',num_step);
fid_disp=fopen('./temp/displ.dat','w');      % opens file for saving displacements
fwrite(fid_disp,num_step,'integer*4');  
hist=zeros(num_step,2);                      % matrix used to store force-disp graph

for istep=1:num_step,                        % loop over load steps 
  disp_k=disp_k+delta*displ;                 % updates boundary conditions       
  residuum=1.d0;  
  k=0;

%-----------------------------------------------------------------------------------------
  if istep>1 
   set(t1,'string',['istep: ' num2str(istep) '   Max. disp: ' ...
          num2str(hist(istep-1,1)) '   Force: ' num2str(R)]);
  end
%-----------------------------------------------------------------------------------------
 
  while(residuum>1.d-8)                      % solution of one step
    k=k+1;
    K(:,:)=0;                                % resets to zero stiffness matrix 
    F=Fg;                                    % initialises F to contribution from tractions
 
%-----------------------------------------------------------------------------------------
    set(t2,'string',['Iteration: ' ...
        num2str(k), '  Toll: ' ...
        num2str(residuum)]);
    pause(.01)
%-----------------------------------------------------------------------------------------
    
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% assemblage phase: siffness matrix K
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

    for e=1:analysis.NE,                     % computes nodal stresses
      nodes=connec(e,:);                     % element nodes
      T=coor(nodes,:);                       % creates element
      Ve=reshape(disp_k(nodes,:)',[Dne,1]);
      [Ke,Fe]=stiff_Ldisp_T3(T,...           % computes element tangent stiff. matrix ...
                            materials.A,Ve); % and contribution to rhs
      dofe=reshape(dof(nodes,:)',[1,Dne]);   % list of dof associated to element
      pe=find(dofe>0);                       % gets position of unknown displ. compon.
      Ie=dofe(pe);                           % gets value of associated DOFs 
      K(Ie,Ie)=K(Ie,Ie)+Ke(pe,pe);           % matrix assemblage
      F(Ie)=F(Ie)-Fe(pe);                    % rhs 
    end
    U=K\F;                                   % solution of linear system
    residuum=sqrt(F'*F);                     % true residuum at previous iteration
    ic=find(dof>0);                          % finds active dofs
    disp_k(ic)=disp_k(ic)+U(dof(ic));        % and copies solution into disp_k
  end                                      
    
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% force computation
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

  R=0;
  for e=1:analysis.NE,                       % loop over elements to compute u^D R
    nodes=connec(e,:);   
    Ve=reshape(disp_k(nodes,:)',[Dne,1]);
    T=coor(nodes,:);                         % creates element
    R=R+force_Ldisp_T3(T,materials.A,Ve);    % element contribution to PPV
  end
  uD=max(abs(displ(:,2)))*istep/num_step;    % value of imposed displacement
  R=R/uD;                                    % force value
  
  [max_d pos]=max(abs(disp_k(:,1)));         % gets max value of or. displ for postproc.
  hist(istep,:)=[disp_k(pos,1),R];       
  fprintf(fid,'%14.6e  %14.6e\n',...
          hist(istep,:));
  fwrite(fid_disp,disp_k,'float32');         % saves displacements to file

end 

fclose(fid);
fclose(fid_disp);

displ=disp_k;
clear K F Fg disp_k hist                     % clears memory

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Post-processing: evalute PK stresses
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

stress=zeros(analysis.NN,3);                 % initializes "stress"
counter=zeros(analysis.NN,1);                % initializes "counter"
for e=1:analysis.NE,                         % computes nodal stresses
 nodes=connec(e,:);
 T=coor(nodes,:);                            % creates element
 Ve=reshape(displ(nodes,:)',[Dne,1]);
 stressN=stressN_Ldisp_T3(T,materials.A,Ve); % points and extrapolates to vertex nodes 
 stress(nodes,:)=stress(nodes,:)+stressN;    % adds stresses to triangle nodes
 counter(nodes)=counter(nodes)+1;
end   
for icomp=1:3
 stress(:,icomp)=stress(:,icomp)./counter;   % naive average of stresses
end

%-----------------------------------------------------------------------------------------
close(figmess)                               % calls function for graphic interface
interface('Initialize',[' mesh-undef| mesh-def| mesh-both| '...
          'ld-history| u1| u2| s11| s22| s12'],'post(infopost)'); 
%-----------------------------------------------------------------------------------------

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Post-processing: compares with buckling force from beam theory
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

bkgcol=.93*[1 1 1];
figure('Color',bkgcol)                       % prepares graphical window
title('Buckling of doubly clamped beam')
xlabel('Mid-span deflection','Fontsize',12)
ylabel('Compressive load','Fontsize',12)
hold on

fid=fopen('./temp/hist.dat','r');            % opens file with analysis data ...
num_step=fscanf(fid,'%d',1);                 % written by beam_ldisp_T3.m
hist=zeros(num_step,2);
for step=1:num_step,                        
 hist(step,:)=fscanf(fid,'%f',2)';           % reads data step by step
end
fclose(fid);
plot(abs(hist(:,1)),abs(hist(:,2)),'ok-')    % plots numerical solution 

L=max(coor(:,2))-min(coor(:,2));             % computes height of beam
H=max(coor(:,1))-min(coor(:,1));             % computes width of beam
J=1/12*H^3;                                  % inertia modulus
buck=4*pi^2*J/(L^2);                         % analytcal buckling force
hist(:,2)=buck;               
plot(abs(hist(:,1)),abs(hist(:,2)),'k-.')    % plots analytical solution
set(gca,'Color','w')                         % sets color of current axes
