
%!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
%!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
% FILE: bar_dyn_B2.M   
% bar with imposed traction
%!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
%!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

addpath(genpath('.'))

clear all

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% user input
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

L=1;                                         % bar length
NE=10;                                       % number of elements
rho=1.;                                      % density
E=1.;                                        % Young modulus
TD=1;                                        % value of traction x=L
tf=20;                                       % final time
Dt=.001;                                     % time step
beta=0;                                      % parameters for Newmark algorithm...
gamma=.5;                                    % beta=0; gamma=.5;  central differences...
                                             % beta=.25; gamma=.5;  incond. stable                                           % stable..
                                
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% pre-processor
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

h=L/NE;                                      % size of one element
NN=NE+1;                                     % number of nodes
coor=[0:h:L]';                               % nodal coordinates: uniform discretization 
neq=NN-1;                                    % number of equations
dof=[0 1:1:NN-1];

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% assemblage of matrices
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

M=zeros(neq,neq);                            % allocates mass matrix
K=zeros(neq,neq);                            % allocates rigidity matrix
F=zeros(neq,1);                              % allocates rhs side

for e=1:NE,                                  % loop over elements to assemble matrices
  S=[coor(e) coor(e+1)];                     % creates segment
  dofe=dof(e:e+1);
  pe=find(dofe>0);
  Ie=dofe(pe);                               % gets value of associated DOFs 
  Me=mass_B2(S,rho);                         % element mass consistent matrix
  M(Ie,Ie)=M(Ie,Ie)+Me(pe,pe);               % assemblage of mass matrix
  Ke=stiff_linel_B2(S,E);                    % element stiffness matrix
  K(Ie,Ie)=K(Ie,Ie)+Ke(pe,pe);               % assemblage of stiffness matrix
end
F(neq)=F(neq)+TD;                            % rhs 

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% initial conditions and acceleration
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

omj2=eigs(K,M,1);                            % computes stability interval for...
stable_time_increment=2/sqrt(omj2)           % explicit option 

U=zeros(neq,1);                              % initial value of displacements
Ud=zeros(neq,1);                             % initial value of velocities
Udd=M\F;                                     % initial value of accelerations
S=M+beta*Dt^2*K;                          
RS=chol(S);                                  % Cholesky decomposition of S matrix 
clear S M  

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% time marching solution
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

nstep=floor(tf/Dt);                          % number of time steps with constant dt
history=zeros(nstep,3);

for step=1:nstep,                            % loop over time steps
  U=U+Dt*Ud+.5*Dt^2*(1-2*beta)*Udd;          % prediction phase for displacements
  Ud=Ud+Dt*(1-gamma)*Udd;                    % prediction phase for velocities
  Fg=F-K*U;      
  Udd=RS\(RS'\Fg);                           % new accelerations 
  U=U+Dt^2*beta*Udd;                         % actualisation of displacements
  Ud=Ud+Dt*gamma*Udd;                        % actualisation of velocities
  history(step,3)=Dt*step;                   % saves hisotry at two points for post-proc.
  history(step,1)=U(neq);
  history(step,2)=U(round(neq/2));
end

clear RS K

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% plots solution
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

bkgcol=.93*[1 1 1];
figure('Color',bkgcol)                       % plots numerical and exact radial displ.
xlabel('Time')
ylabel('Displacement')
plot(history(:,3),history(:,1),'k-') 
hold on
plot(history(:,3),history(:,2),'k--') 
axis([0 tf min(history(:,1)) ...
	                max(history(:,1))]);
xlabel('Time','FontSize',12)
ylabel('Displacement','FontSize',12)
legend('Tip point','Mid point') 
set(gca,'Color','w')                         % sets color of current axes

