
%!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
% Radial Return for Von Mises Linear Isotropic Hardening
%!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
function [Dp,sigma_new]=RR_VonMises(E,nu,H,sigma0,sigma,p,Deps)

mu=E/(2*(1+nu));
kappa=E/(3*(1-2*nu));
vl=[1 1 1 0]';

trDeps=Deps(1)+Deps(2);                      % trace of increment of def.
De=[Deps(1:2); 0; Deps(3)/2]-1/3*trDeps*vl;    % full 3D deviatoric tensor 
sigma_elas=sigma+kappa*trDeps*vl+2*mu*De;    % elastic prediction of global stresses 
trsigma=sum(sigma_elas(1:3));                % volumetric part  
s_elas=sigma_elas-1/3*trsigma*vl;            % deviatoric elastic prediction
sigeq_elas=sqrt(1.5*...                      % equivalent deviatoric stress 
            (s_elas(1)^2+s_elas(2)^2+ ...
             s_elas(3)^2+2*s_elas(4)^2));    
f_elas=sigeq_elas-H*p-sigma0;
if(f_elas>0)                                 % if plastic process
  Dp=f_elas/(3*mu+H);                        % increment of plastic eq. strain
  sigeq_new=sigeq_elas-3*mu*Dp;              % new equivalent stress
  Depsp=3/2*Dp*s_elas/sigeq_elas;            % increment over step of plastic defs.
		sigma_new=sigma_elas-2*mu*Depsp;
else                                         % elseif elastic process
  Dp=0;   
  sigma_new=sigma_elas;                      % new total stress
end


