
%!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
%  Local plastic correction for T6
%!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
function [KEPe,Finte,sigma_new,Dp]=lcorr_T6(DUe,T,p,sigma,materials)
 
a_gauss=1/6*[4 1 1; 1 4 1; 1 1 4];           % Gauss abscissae
w_gauss=1/6*[1 1 1];                         % Gauss weights
Finte=zeros(12,1);
KEPe=zeros(12,12);                           % element elastoplastic matrix
sigma=reshape(sigma,3,4);
sigma_new=zeros(3,4);
for g=1:3,                                   % loop over gauss points
  a=a_gauss(g,:);                            % area coord. for gauss point
  DN=[4*a(1)-1 0 -4*a(3)+1 4*a(2)...         % derivative of shape functions...
      -4*a(2) 4*(a(3)-a(1));                 % w.r.t. a_1,a_2
      0 4*a(2)-1 -4*a(3)+1 4*a(1) ...
      4*(a(3)-a(2)) -4*a(1)]';
  J=T'*DN;                                   % jacobian matrix
  detJ=J(1,1)*J(2,2)-J(1,2)*J(2,1);          % jacobian
  invJ=1/detJ*[ J(2,2) -J(1,2); ...          % inverse jacobian matrix
               -J(2,1)  J(1,1)];
  GN=DN*invJ;                                % gradient of shape functions
  Be=[GN(1,1) 0 GN(2,1) 0 GN(3,1) 0 ...
      GN(4,1) 0 GN(5,1) 0 GN(6,1) 0;
      0 GN(1,2) 0 GN(2,2) 0 GN(3,2)...
      0 GN(4,2) 0 GN(5,2) 0 GN(6,2);
      GN(1,2) GN(1,1) GN(2,2) GN(2,1)...
      GN(3,2) GN(3,1) GN(4,2) GN(4,1)...
      GN(5,2) GN(5,1) GN(6,2) GN(6,1)];
  Deps=Be*DUe;                               % computes elastic increment of stresses
  [Aep,Dp(g),sigma_new(g,:)]=...
        RR_VonMisesTM(materials.A,...
        materials.young,materials.poisson,...
        materials.H,materials.sigma0,...
        sigma(g,1:4)',p(g),Deps);
  KEPe=KEPe+Be'*Aep*Be*detJ*w_gauss(g);      % tangent stiffness matrix
  Finte=Finte-Be'*sigma_new(g,[1:2 4])'*...  % equivalent nodal forces (plane strain!)
                          detJ*w_gauss(g);  
end

