
%!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
%  Element stiffness matrix, large displacements: T3
%!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
function [Ke,Fe]=stiff_Ldisp_T3(T,A,Ve)

x11=T(1,1); x21=T(2,1); x31=T(3,1);          % nodal coordinates 
x12=T(1,2); x22=T(2,2); x32=T(3,2);
S=((x21-x11)*(x32-x12)-...
   (x31-x11)*(x22-x12))/2;
G=1/(2*S)*[x22-x32,0,x32-x12,0,x12-x22,0;    % gradient matrix 
           x31-x21,0,x11-x31,0,x21-x11,0;
           0,x22-x32,0,x32-x12,0,x12-x22;
           0,x31-x21,0,x11-x31,0,x21-x11];
grad=G*Ve;                                   % gradient of u^{(k)}
e=[grad(1)+.5*grad(1)^2+.5*grad(3)^2, ...    % Green-Lagrange tensor e^{(k)} 
   grad(4)+.5*grad(2)^2+.5*grad(4)^2, ...
   grad(2)+grad(3)+grad(1)*grad(2)+ ...     
   grad(3)*grad(4)]';
PK=A*e;                                      % Piola Kirkhhoff tensor pi^{(k)}
Be=[G(1,:); G(4,:); G(2,:)+G(3,:)];
Bu=[grad(1)*G(1,:)+grad(3)*G(3,:);
    grad(2)*G(2,:)+grad(4)*G(4,:);
    grad(1)*G(2,:)+grad(3)*G(4,:)+ ...
    grad(2)*G(1,:)+grad(4)*G(3,:)];
Bt=Be+Bu;
Bp=[PK(1)*G(1,:)+PK(3)*G(2,:);  
    PK(3)*G(1,:)+PK(2)*G(2,:);
    PK(1)*G(3,:)+PK(3)*G(4,:);
    PK(3)*G(3,:)+PK(2)*G(4,:)];
Ke=(Bt'*A*Bt+G'*Bp)*S;
Fe=Bt'*PK*S;

