
%!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
% FILE: nf_gravity_T3.m
% Nodal forces due to gravity along e2 direction: T3
%!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
function Fe=nf_gravity_T3(T,rhog)

x11=T(1,1); x21=T(2,1); x31=T(3,1);          % nodal coordinates
x12=T(1,2); x22=T(2,2); x32=T(3,2);
S=.5*((x21-x11)*(x32-x12)-...
      (x31-x11)*(x22-x12));                  % element area
Fe=-1/3*rhog*S*[0 1 0 1 0 1]';


