
%!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
%!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
% FILE: strip_plast.m
% Plane strain strip under uniform tension
%!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
%!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

addpath(genpath('.'))

clear all

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% User input
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

L=1;                                         % halflength of strip
E=100;                                       % Young modulus
nu=.1;                                       % Poisson coefficient
sigma0=1;                                    % yield limit     
H=0;                                         % hardening parameter
q=[0:.002:.1];                               % history of imposed displacements

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Pre-processor
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

numstep=length(q);                           % number of steps
p=0;                                         % initialisation of plastic strains
sigma=zeros(4,1);                            % initialisation of stresses
sigma_old=sigma;                             
output=zeros(numstep,2);       
toll=1.d-4;                                  % user fixed tolerance

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% History analysis
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

for istep=2:numstep,                         % loop over all load steps
  Dq=q(istep)-q(istep-1);                    % delta of displacement applied in step
  iter=0;
  resid=1;
  Dp=0;                                      % init. of plastic mult. increment in step
  Deps=zeros(3,1);
  while resid > toll,                        % solution of one load step
    iter=iter+1;   
    if iter==1                               % imposes equilibrium: sigmayy=0 
      Deps=Dq/(2*L)*[1 -nu/(1-nu) 0]';       % increment of total epsxx
    else 
      Depsyy=-sigma_new(2)*(1+nu)* ...
                       (1-2*nu)/(E*(1-nu));           
      Deps=Deps+[0 Depsyy 0]';
    end
    [Dp,sigma_new]=RR_VonMises(E,nu, ...     % radial return algorithm
                    H,sigma0,sigma,p,Deps);
    resid=abs(sigma_new(2));                 % abs value of sigyy taken as residuum
  end                                        % end of one load step
  p=p+Dp;                                    % increments plastic multiplier
  sigma=sigma_new;
  output(istep,:)=[sigma(1) sigma(3)];
end                                          % end loop over time steps

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Post-processing: comparison with exact results
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

history=q/(2*L);
thetae=asin(sqrt(3)/(2*sqrt(1-nu+nu^2)))-pi/6;
sigmae=sigma0/sqrt(1-nu+nu^2);
epse=(1-nu^2)/E*sigmae;
const=epse-2*sigma0/(sqrt(3)*E)*...
	     (3/4*log(abs(tan(thetae/2+pi/3)))+...
      (1-2*nu)*sin(thetae-pi/6));
vtheta=[thetae:.01:pi/3];
vsigmaxx=2*sigma0/sqrt(3)*sin(vtheta+pi/6);
vsigmazz=2*sigma0/sqrt(3)*sin(vtheta-pi/6);
veps=const+2*sigma0/(sqrt(3)*E)*...
	      (3/4*log(abs(tan(vtheta/2+pi/3)))+...
       (1-2*nu)*sin(vtheta-pi/6));
veps=[0 veps];
vsigmaxx=[0 vsigmaxx];
vsigmazz=[0 vsigmazz];
           
figure('Color','w')
plot(veps,vsigmaxx,'k-.')
hold on
plot(veps,vsigmazz,'k-')
hold on
plot(history,output(:,1),'ko')
hold on
plot(history,output(:,2),'k+')
axis([min(veps),max(veps),...
	     min(vsigmazz),1.1*max(vsigmaxx)])

xlabel('\epsilon_{xx}','Fontsize',12)
ylabel('\sigma','Fontsize',12)
legend('Exact \sigma_{xx}',...
	      'Exact \sigma_{zz}', ...
       'Numerical \sigma_{xx}',...
	      'Numerical \sigma_{zz}',...
	      'Location','SouthEast') 

