
%!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
%!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
% File post_fract_T
%!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
%!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

addpath(genpath('.'))

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% K postprocessing phase from displacements
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

a=1.;                                        % crack halflength
H=5.;                                        % plate halfwidth
vec=find((abs(coor(:,2))<1.d-6)& ...         % finds nodes on x_2=0 ... 
         (abs(coor(:,1))<(a-1.d-5)));        % and to the left of x_B
coor_K=max(coor(vec,1));
nodes_K=vec(find(abs(coor(vec,1)- ...        % finds nodes closer to tip
                         coor_K)<1.d-5));
delta_disp=displ(nodes_K(2),2)- ...          % evaluates displ. discont. on these nodes
           displ(nodes_K(1),2);
d=a-coor_K;
K_H=sqrt(pi*a)* ...                          % analytical solution for V->infty
        sqrt(sec(pi*a/(2*H)))
K_disp=materials.young...                    % numerical K from displ.
          /(8*(1-materials.poisson^2)) ...  
          *sqrt(2*pi/d)*abs(delta_disp)


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% K postprocessing phase from gtheta method: implemented only for T3
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

Ri=.1;                                       % defines outer circle for theta=1 region
Re=.5;                                       % and inner circle for theta=0 region 
vec_dist=sqrt((coor(:,1)-a).^2+...           % vector of distances from crack tip
               coor(:,2).^2);
theta=zeros(analysis.NN,2);                 
nodes_gtheta=find(vec_dist<(Ri-1.d-5));      % list of nodes in theta=1 region
theta(nodes_gtheta,1)=1.;                    
nodes_gtheta=find(vec_dist<(Re+1.d-5) ...    % list of nodes in middle region
                &(vec_dist>(Ri-1.d-5)));
theta(nodes_gtheta,1)=1.-...                 % imposes linear theta field
          (vec_dist(nodes_gtheta)-Ri)/...
          (Re-Ri);

GB=0.;
for e=1:analysis.NE,                         % computation of GB element by element
  nodes=connec(e,:);
  Ve=reshape(displ(nodes,:)',[Dne,1]);
  Ge=reshape(theta(nodes,:)',[Dne,1]);       % gets nodal values of theta
  T=coor(nodes,:);                           % creates element
  GBe=eval(['gtheta_T',analysis.Etag,...     % computes element contrib. to GB
                  '(T,materials.A,Ve,Ge)']);   
  GB=GB+GBe;             
end
K_GB=sqrt(materials.young/...                % extrapolation of K_GB
             (1-materials.poisson^2)*GB)


