
%!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
%!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
% FILE: plast_T.m
% Plane strain plastic analyses (T3 and T6) for linear hardening Von-Mises
% constitutive law
%!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
%!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

addpath(genpath('.'))

clear all
global displ analysis coor connec stress p

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% input phase
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

[fname,pname]=uigetfile('input/*.inp',...    % gets name of input file
                        'Choose input file');

%-----------------------------------------------------------------------------------------
[figmess,t1,t2]=createfigmess;
set(t1,'string','Pre phase');
%-----------------------------------------------------------------------------------------

[analysis,materials,connec,coor,...           % reads input file
   dof,displ,TD]=read_input(pname,fname,t2);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% preprocessor phase
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

switch analysis.Etag                         % coeffs of the relation between Nk and Ek
case{'3'}
  c1=2; c2=1;
case{'6'}
  c1=3; c2=3;
end
Ek=c1*ones(analysis.NN,1);                   % initialisation of Ek
for e=1:analysis.NE,                         % loop over elements
  nodes=connec(e,:);
  Ek(nodes)=Ek(nodes)+c2;                    % Ek is incremented on connectivity nodes
end
ncoeffs=4*sum(Ek);                           % sum of all the terms in Ek

KEP=spalloc(analysis.neq,analysis.neq, ...
                                   ncoeffs); % allocates sparse matrix

Fint=zeros(analysis.neq,1);                  % allocates rhs vector for internal forces
FDu=zeros(analysis.neq,1);                   % allocates rhs vector for imp. displ.
Fext=zeros(analysis.neq,1);                  % allocates rhs vector for tractions

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% initialisation phase: elastic siffness matrix K 
% and nodal loads equivalent to tractions
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%-----------------------------------------------------------------------------------------
set(t1,'string',['Number of elements: ' num2str(analysis.NE)]);
set(t2,'string','Assembling elastic matrix and loads');
pause(.01); 
%-----------------------------------------------------------------------------------------

D=2;                                         % problem Dnensionality
Dne=D*analysis.ne;                           % number of nodal values in one surface el.
Dns=D*analysis.ns;                           % number of nodal values in one line el.
for e=1:analysis.NE,                         % loop over elements to assemble
  nodes=connec(e,:);                         % element nodes
  T=coor(nodes,:);                           % creates element
  Ke=eval(['stiff_linel_T',analysis.Etag,...
                   '(T,materials.A)']);      % computes element stiffness matrix
  dofe=reshape(dof(nodes,:)',[1,Dne]);       % list of dof associated to element
  pe=find(dofe>0);                           % gets position of unknown displ. compon.
  Ie=dofe(pe);                               % gets value of associated DOFs 
  KEP(Ie,Ie)=KEP(Ie,Ie)+Ke(pe,pe);           % matrix assemblage
  pe_UDe=find(dofe<0);                       % gets position of given displ. compon.
  Ie_UDe=-dofe(pe_UDe);                      % gets position in 1D vector equiv. to ``disp'' 
  UDe=displ(Ie_UDe)';                        % gets displacement values
  FDu(Ie)=FDu(Ie)-Ke(pe,pe_UDe)*UDe;         % rhs from DBCs
end

for s=1:analysis.nTD,                        % for each loaded face in the model
  nodes=TD(s).nodes;                         % gets nodes
  dir=TD(s).dir;                             % gets direction
  val=TD(s).val;                             % gets traction value
  L=coor(nodes,:);                           % creates segment   
  Fe=eval(['nf_tractions_T',...
              analysis.Etag,'(L,val,dir)']); 
  dofs=reshape(dof(nodes,:)',[Dns,1]);       % list of dof associated to element 
  ps=find(dofs>0);                           % finds non-zero entries of dofe
  Is=dofs(ps); 
  Fext(Is)=Fext(Is)+Fe(ps);                  % adds to global rhs
end 
 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% history analysis
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

imposed_disp=displ;                          % saves the matrix of imposed displacements
ng=analysis.ng;                              % number of Gauss points
pG=zeros(analysis.NE,ng);                    % initial eq. plastic strain in gauss points to zero
DpG=zeros(analysis.NE,ng);                   % increment over one step
stressG=zeros(analysis.NE,ng,4);             % stresses at Gauss points
stressG_new=zeros(analysis.NE,ng,4);         % stresses at Gauss points after step
displ(:,:)=0;                                % initial displacements set to zero

for step=1:analysis.numstep,                 % loop over all load steps
    
%-----------------------------------------------------------------------------------------
  set(t1,'string',['Analysis phase. Total steps: ' num2str(analysis.numstep)]);
  set(t2,'string',['Step: ' num2str(step) ' Iter: ' num2str(0) ' Toll: ' num2str(1)]);
  pause(.01);
%-----------------------------------------------------------------------------------------
  
  Dlambda=analysis.history(step+1)- ...
          analysis.history(step);            % delta of load multiplier applied in step
  Ddisp=Dlambda*imposed_disp;                % initialisation of displ. incr. in step 
  R=-Fext*analysis.history(step+1)-Fint- ...
			                            FDu*Dlambda;  % initialisation of residuum vector
  resid=sqrt(R'*R);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% NR procedure for one single step
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

  iter=0;
  toll=1.d-4; 
  while resid > toll,    
    iter=iter+1;   

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% global elastic prediction
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

    DDu=-KEP\R;                              % prediction with consistent KEP
    ir=find(dof>0);                          % finds non-zero entries in "dof"
    Ddisp(ir)=Ddisp(ir)+DDu(dof(ir));        % updates displacements

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% local plastic correction
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

    KEP(:,:)=0.d0;
    FDu(:)=0;                                % sets FDu to zero
    Fint(:)=0;                               % sets Fint to zero
    for e=1:analysis.NE,                     % loop over elements
      nodes=connec(e,:);
      DUe=reshape(Ddisp(nodes,:)',[Dne,1]);  % increments of nodal displ. 
      T=coor(nodes,:);                       % creates element
      dofe=reshape(dof(nodes,:)',[1,Dne]);   % list of dof associated to element
      pe=find(dofe>0);                       % gets position of unknown displ. compon.
      Ie=dofe(pe);                           % gets value of associated DOFs 
      [KEPe,Finte,stressG_new(e,:,:),DpG(e,:)]=...
         eval(['lcorr_T',analysis.Etag, ...
               '(DUe,T,pG(e,:),'...
               'stressG(e,:,:),materials)']); 
      KEP(Ie,Ie)=KEP(Ie,Ie)+KEPe(pe,pe);     % matrix assemblage
      pe_UDe=find(dofe<0);                   % gets position of given displ. compon.
      Ie_UDe=-dofe(pe_UDe);                  % gets position in 1D vector equiv. to ``disp'' 
      UDe=imposed_disp(Ie_UDe)';             % gets displacement values
      FDu(Ie)=FDu(Ie)-KEPe(pe,pe_UDe)*UDe;   % rhs from DBCs          
      Fint(Ie)=Fint(Ie)+Finte(pe);           % assembling vector of internal forces
	   end                 
    R=-Fext*analysis.history(step+1)-Fint;   % residuum vector
    resid=sqrt(R'*R);        

%-----------------------------------------------------------------------------------------
    set(t2,'string',['Step: ' num2str(step) ...
                     ' Iter: ' num2str(iter) ' Toll: ' num2str(resid)]);
    pause(.01);
%-----------------------------------------------------------------------------------------
  
  end                                        % end of iterations in one time step
  pG=pG+DpG;                                 % updates equivalent plastic strains
  stressG=stressG_new;                       % updates stress at Gauss points
  displ=displ+Ddisp;                         % updates displacements
end                                          % end loop over time steps

clear KEP Fext FDu Fint Ddisp stressG_new    % clears memory

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Post-processing phase
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

stress=zeros(analysis.NN,3);                 % initializes stress
p=zeros(analysis.NN,1);                      % initializes p
counter=zeros(analysis.NN,1);                % initializes counter
for e=1:analysis.NE,                        
  stressGe=reshape(stressG(e,:,[1:2 4]),...  % stresses at gauss points
            [ng,3]);   
  stressN=eval(['G2N_T',...                  % extrapolation to nodal stresses 
            analysis.Etag,'(T,stressGe)']);   
  pGe=reshape(pG(e,:),[ng,1]);               % equiv. plastic strain at gauss points
  pN=eval(['G2N_T',...                       % gauss to nodal equiv. plastic strain 
                 analysis.Etag,'(T,pGe)']);   
  nodes=connec(e,:);   
  stress(nodes,:)=stress(nodes,:)+stressN;   % adds stresses to triangle nodes
  p(nodes,:)=p(nodes,:)+pN;                  % adds stresses to triangle nodes
  counter(nodes)=counter(nodes)+1;
end   
p=p./counter;                                % nodal average of equiv. plastic strains
for icomp=1:3
 stress(:,icomp)=stress(:,icomp)./counter;   % nodal average of stresses
end

%-----------------------------------------------------------------------------------------
close(figmess)
interface('Initialize',[' mesh-undef| mesh-def| mesh-both| u1| u2| s11| s22| s12| p'],...
          'post(infopost)'); 
%-----------------------------------------------------------------------------------------

