
%!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
%!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
% file: linel_T_fast.m
% Elastic analyses for plane analyses with linear and quadratic triangles
%!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
%!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

addpath(genpath('.'))

clear all
global displ analysis coor connec stress     % global variables for post-processing

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% preprocessor phase: reads input from file
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

[fname,pname]=uigetfile('input/*.inp',...    % gets name of input file
                        'Choose input file');
                                                                                    
%-----------------------------------------------------------------------------------------
[figmess,t1,t2]=createfigmess;
set(t1,'string','Pre phase');
%-----------------------------------------------------------------------------------------

[analysis,materials,connec,coor,...           % reads input file
   dof,displ,TD]=read_input(pname,fname,t2);


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% estimate of number of non-zero coefficients for Morse stocking
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

switch analysis.Etag                         % coeffs of the relation between Nk and Ek
case{'3','3axi'}
  c1=2; c2=1;
case{'6','6axi'}
  c1=3; c2=3;
end
Ek=c1*ones(analysis.NN,1);                   % initialisation of Ek
for e=1:analysis.NE,                         % loop over elements
  nodes=connec(e,:);
  Ek(nodes)=Ek(nodes)+c2;                    % Ek is incremented on connectivity nodes
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% preliminary allocation of workspace with Morse stocking
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

startrow=zeros(analysis.neq,1);              % index of row start
lenrow=zeros(analysis.neq,1);                % dim of row
ncoeffs=0;
for n=1:analysis.NN,                         % loop over nodes
  for dir=1:2                                % loop over directions
    ndof=dof(n,dir);                         % DOF associated to node and idir
    if ndof>0,                               % only if unknwon displacement
      startrow(ndof)=ncoeffs+1;
      ncoeffs=ncoeffs+2*Ek(n);               % increments number of coefficients
    end
  end
end
Cm=zeros(ncoeffs,1);                         % allocates Cm
Jm=zeros(ncoeffs,1);                         % allocates Jm vector
F=zeros(analysis.neq,1);                     % rhs vector
count_coeff=0;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% assemblage phase: siffness matrix K
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%-----------------------------------------------------------------------------------------
set(t1,'string',['Number of elements: ' num2str(analysis.NE)]);
set(t2,'string','Assembling: 0%'); pause(.01);
percold=0; 
%-----------------------------------------------------------------------------------------

%pre_fract_T                                 % uncomment for use with T6QP and fracture

D=2;                                         % problem dimensionality
Dne=D*analysis.ne;                           % number of nodal values in one surface el.
Dns=D*analysis.ns;                           % number of nodal values in one line el.
for e=1:analysis.NE,                         % assemblage of stiffness matrix

%-----------------------------------------------------------------------------------------
  perc=10*floor(10*e/analysis.NE);
  if perc~=percold,
    percold=perc;
    set(t2,'string',['Assembling: ' num2str(percold) '%']);  pause(.01)
		end    
%-----------------------------------------------------------------------------------------
    
  nodes=connec(e,:);                         % element nodes
  T=coor(nodes,:);                           % creates element   
  Ke=eval(['stiff_linel_T',analysis.Etag,...
                  '(T,materials.A)']);       % computes element stiffness matrix
  dofe=reshape(dof(nodes,:)',[1,Dne]);       % list of DOF associated to element 
  pe=find(dofe>0);                           % finds unknown displ. components
  Ie=dofe(pe);
  dim=length(Ie);                            % number of active DOFs
  for i1=1:dim
    p=pe(i1);                                % local number of unknown
    I=Ie(i1);                                % global number of unknown
    inRow=startrow(I);                       % initial position of row I
    dimRow=lenrow(I);                        % length of row I
    for i2=1:dim                             % loop over all columns in row I
      q=pe(i2);                              % local number of unknown in column i2
      J=Ie(i2);                              % global number of unknown in column i2
      ipos=find(Jm(inRow:inRow+dimRow-1)...
							                                ==J); % verifies if coefficients already exists
      if isempty(ipos),                      % if not creates a new coefficient
        dimRow=dimRow+1;
        lenrow(I)=dimRow;
        Jm(inRow+dimRow-1)=J;
        Cm(inRow+dimRow-1)=Ke(p,q);
        count_coeff=count_coeff+1;
      else                                   % otherwise adds the contribution
        Cm(inRow+ipos-1)= ...
              Cm(inRow+ipos-1)+Ke(p,q);
      end
    end
  end
  pe_UDe=find(dofe<0);                       % finds given displ. components
  Ie_UDe=-dofe(pe_UDe);
  UDe=displ(Ie_UDe)';                        % gets displacement values
  F(Ie)=F(Ie)-Ke(pe,pe_UDe)*UDe;             % rhs from DBCs
end
Im=zeros(count_coeff,1);
pos=1;
for i1=1:analysis.neq,
  dimRow=lenrow(i1);
  inRow=startrow(i1);
  Im(pos:pos+dimRow-1)=i1;
  Jm(pos:pos+dimRow-1)=...
	 	             Jm(inRow:inRow+dimRow-1);
  Cm(pos:pos+dimRow-1)=...
		              Cm(inRow:inRow+dimRow-1);
  pos=pos+dimRow;
end
K=sparse(Im,Jm(1:count_coeff),...
	                    Cm(1:count_coeff));
clear Im Jm Cm startrow lenrow

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% assemblage phase: nodal equivalent loads
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%-----------------------------------------------------------------------------------------
set(t2,'string',['Creating rhs']); pause(.01)
%-----------------------------------------------------------------------------------------

for s=1:analysis.nTD,                        % for each loaded face in the model
 nodes=TD(s).nodes;                          % gets nodes
 idir=TD(s).dir;                             % gets direction
 val=TD(s).val;                              % gets traction value
 L=coor(nodes,:);                            % creates segment   
 Fe=eval(['nf_tractions_T',...
            analysis.Etag,'(L,val,idir)']); 
 dofs=reshape(dof(nodes,:)',[Dns,1]);        % list of dof associated to element 
 ps=find(dofs>0);                            % finds non-zero entries of dofe
 Is=dofs(ps); 
 F(Is)=F(Is)+Fe(ps);                         % adds to global rhs
end 
 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Solution phase
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%-----------------------------------------------------------------------------------------
set(t2,'string',['Solving system']); pause(.01)
%-----------------------------------------------------------------------------------------

U=K\F;                                       % solution of linear system

clear K F                                    % clears memory

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Post-processing phase
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

ic=find(dof>0);                              % finds active dofs
displ(ic)=U(dof(ic));                        % and copies solution into displ

stress=zeros(analysis.NN,3);                 % initializes "stress"
counter=zeros(analysis.NN,1);                % initializes "counter"
for e=1:analysis.NE,                         % computes nodal stresses
  nodes=connec(e,:);
  T=coor(nodes,:);                           % creates element
  Ve=reshape(displ(nodes,:)',[Dne,1]);
  stressG=eval(['stressG_linel_T',...        % computes stresses in one element at gauss...
      analysis.Etag,'(T,materials.A,Ve)']);  % points
  stressN=eval(['G2N_T',...                  % and extrapolates to vertex nodes 
      analysis.Etag,'(T,stressG)']);   
  stress(nodes,:)=stress(nodes,:)+stressN;   % adds stresses to triangle nodes
  counter(nodes)=counter(nodes)+1;
end   
for icomp=1:3
  stress(:,icomp)=stress(:,icomp)./counter;  % naive average of stresses
end

%-----------------------------------------------------------------------------------------
% calls function for graphic interface
close(figmess)
interface('Initialize',[' mesh-undef| mesh-def| mesh-both| u1|'...
          ' u2| s11| s22| s12'],'post(infopost)'); 
%-----------------------------------------------------------------------------------------


