
%!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
% Stresses in one T3 element due to displacements Ve (constant): linear
% elastic constitutive law
%!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
function stressG=stressG_linel_T3(T,A,Ve)

x11=T(1,1); x21=T(2,1); x31=T(3,1);          % nodal coordinates
x12=T(1,2); x22=T(2,2); x32=T(3,2);
S=.5*((x21-x11)*(x32-x12)-...
      (x31-x11)*(x22-x12));                  % element area
Be=[x22-x32,0,x32-x12,0,x12-x22,0;
    0,x31-x21,0,x11-x31,0,x21-x11;
    x31-x21,x22-x32,x11-x31, ...
    x32-x12,x21-x11,x12-x22]/(2*S);
stressG=(A*Be*Ve)';
