
%!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
% Nodal forces due to surface tractions: T3
%!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
function Fe=nf_tractions_T3(L,val,idir)

x11=L(1,1); x12=L(1,2);                      % first node
x21=L(2,1); x22=L(2,2);                      % second node
H=sqrt((x21-x11)^2+(x22-x12)^2);             % element length
NL=H/2*[1 0 1 0;
        0 1 0 1];
TD=zeros(2,1);                               % traction vector
if idir>0,                                   % if cartesian direction
  TD(idir)=val;
else                                         % if along normal
  n=[(x22-x12); -(x21-x11)]/H;               % unit normal vector
  TD=val*n;
end
Fe=NL'*TD;                                   % elementary nodal forces due to tractions

