
%!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
% Large Displacement Analysis: subroutine for evaluating forcesno Su
% regions via PPV
%!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
function Fe=force_Ldisp_T3(T,A,Ve)

x11=T(1,1); x21=T(2,1); x31=T(3,1);          % nodal coordinates
x12=T(1,2); x22=T(2,2); x32=T(3,2);
S=((x21-x11)*(x32-x12)-...
	              (x31-x11)*(x22-x12))/2;       % element area
G=1/(2*S)*[x22-x32,0,x32-x12,0,x12-x22,0;    % gradient matrix 
           x31-x21,0,x11-x31,0,x21-x11,0;
           0,x22-x32,0,x32-x12,0,x12-x22;
           0,x31-x21,0,x11-x31,0,x21-x11];
grad=G*Ve;                                   % gradient of u_h
Be=[G(1,:); G(4,:); G(2,:)+G(3,:)];
Bu=[grad(1)*G(1,:)+grad(3)*G(3,:);
    grad(2)*G(2,:)+grad(4)*G(4,:);
    grad(1)*G(2,:)+grad(3)*G(4,:)+ ...
    grad(2)*G(1,:)+grad(4)*G(3,:)];
Bt=Be+Bu;
e=[grad(1)+.5*grad(1)^2+.5*grad(3)^2, ...    % Green Lagrange tensor
   grad(4)+.5*grad(2)^2+.5*grad(4)^2, ...
   grad(2)+grad(3)+grad(1)*grad(2)+ ...
   grad(3)*grad(4)]';
PK=A*e;                                      % Piola Kirchhoff tensor
Fe=PK'*Bt*Ve*S;                              % contribution to PPV 

