
%!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
% FILE: sphere_cond_B2.m
% computes element conductivity matrix for B2 element with spherical symmetry
% IN: 
% S(2)            vector with nodal coordonates of element
% k               conductivity
% OUT:
% Ce(2,2)         conductivity matrix
%!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
function Ce=sphere_cond_B2S(S,k)

r1=S(1); r2=S(2);                            % node coordinates
h=r2-r1;                                     % element length 
Ce=k/(3*h)*(r1^2+r1*r2+r2^2)*[1,-1; -1,1];   % element conductivity matrix

