
%!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
% FILE: caplump_B2S.M 
% lumped element capacity matrix for 2 nodes line element with spherical symmetry
%!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
function Me=caplump_B2S(S,c)

r1=S(1); r2=S(2);                            % radial coordinates of element
h=r2-r1;                                     % length of element
mass=1/3*c*h*(r1^2+r1*r2+r2^2);              % total element mass
Me=[12*r1^2+6*r1*r2+2*r2^2 ...               % diagonal coefficients of consistent matrix
    2*r1^2+6*r1*r2+12*r2^2]';
mass_f=Me(1)+Me(2);
Me=Me*mass/mass_f;                           % scaling to get correct mass

